Attribute VB_Name = "USBDefs"
Option Explicit

' Windows API definitions

'from setupapi.h
Public Const DIGCF_PRESENT = &H2
Public Const DIGCF_DEVICEINTERFACE = &H10

Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Public Const GENERIC_READ = &H80000000
Public Const GENERIC_WRITE = &H40000000

'Modified
'09/17/03
'by Paul Deignan
Public Const GENERIC_NOACCESS = 0

Public Const FILE_SHARE_READ = &H1
Public Const FILE_SHARE_WRITE = &H2
Public Const FILE_FLAG_OVERLAPPED = &H40000000
Public Const ERROR_IO_PENDING = 997
Public Const ERROR_IO_INCOMPLETE = 996

'from winerror.h
Public Const ERROR_INSUFFICIENT_BUFFER = 122

'from winbase.h
Public Const INVALID_HANDLE_VALUE = &HFFFFFFFF

'from hidpi.h
Public Const HIDP_STATUS_SUCCESS = &H110000

'Typedef enum defines a set of integer constants for HidP_Report_Type
'Remember to declare these as integers (16 bits)
Public Const HidP_Input = 0
Public Const HidP_Output = 1
Public Const HidP_Feature = 2

Public Const OPEN_EXISTING = 3

' Mag-Tek device definitions

Public Const MagTekVendorID = &H801
Public Const HIDMSRKeyBoardEmulProdID = &H1
Public Const HIDMSRVendDefProdID = &H2
Public Const InsertRdrProdID = &H3
Public Const HIDMSRVendDefMagnePrintProdID = &H9

'HID USB swipe reader usages
Public Const UPG_MSR = &HFF00
Public Const UID_DECODING_RDR = &H1
Public Const UID_TRACK_1_DECODE_STATUS = &H20
Public Const UID_TRACK_2_DECODE_STATUS = &H21
Public Const UID_TRACK_3_DECODE_STATUS = &H22
Public Const UID_MAGNEPRINT_STATUS = &H23
Public Const UID_TRACK_1_LEN = &H28
Public Const UID_TRACK_2_LEN = &H29
Public Const UID_TRACK_3_LEN = &H2A
Public Const UID_MAGNEPRINT_LEN = &H2B
Public Const UID_TRACK_1_DATA = &H30
Public Const UID_TRACK_2_DATA = &H31
Public Const UID_TRACK_3_DATA = &H32
Public Const UID_MAGNEPRINT_DATA = &H33
Public Const UID_CARD_ENCODE_TYPE = &H38
Public Const UID_CARD_STATUS = &H39
Public Const UID_DEVICE_SERIAL_NUMBER = &H40
Public Const UID_SEQUENCE_COUNTER = &H41

' Card status bit definitions
Public Const CS_CARD_INSERTED = &H1

'Decode status
Public Const DS_ERROR = &H1

'Card encode types
Public Const MSD_CET_ISO = 0
Public Const MSD_CET_AAMVA = 1
Public Const MSD_CET_CA = 2
Public Const MSD_CET_BLANK = 3
Public Const MSD_CET_OTHER = 4
Public Const MSD_CET_UNDETERMINED = 5
Public Const MSD_CET_NONE = 6

'Feature report indexes
Public Const FRI_CMD = 1
Public Const FRI_LEN = 2
Public Const FRI_DATA = 3
Public Const FRI_RC = 1

'Send command status
Public Const SCS_SUCCESS = 0
Public Const SCS_TRX_FAILED = 1
Public Const SCS_RCV_FAILED = 2

'******************************************************************************
'User-defined types for API calls, listed alphabetically
'******************************************************************************

Public Type GUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(7) As Byte
End Type

Public Type HIDD_ATTRIBUTES
    Size As Long
    VendorID As Integer
    ProductID As Integer
    VersionNumber As Integer
End Type

'Windows 98 DDK documentation is incomplete.
'Use the structure defined in hidpi.h
Public Type HIDP_CAPS
    Usage As Integer
    UsagePage As Integer
    InputReportByteLength As Integer
    OutputReportByteLength As Integer
    FeatureReportByteLength As Integer
    Reserved(16) As Integer
    NumberLinkCollectionNodes As Integer
    NumberInputButtonCaps As Integer
    NumberInputValueCaps As Integer
    NumberInputDataIndices As Integer
    NumberOutputButtonCaps As Integer
    NumberOutputValueCaps As Integer
    NumberOutputDataIndices As Integer
    NumberFeatureButtonCaps As Integer
    NumberFeatureValueCaps As Integer
    NumberFeatureDataIndices As Integer
End Type

'If IsRange is false, UsageMin is Usage and UsageMax is unused.
'If IsStringRange is false, StringMin is StringIndex and StringMax is unused.
'If IsDesignatorRange is false, DesignatorMin is DesignatorIndex and DesignatorMax is unused.
Public Type HIDP_VALUE_CAPS
    UsagePage As Integer
    ReportID As Byte
'    IsAlias As Byte
    BitField As Integer
    LinkCollection As Integer
    LinkUsage As Integer
    LinkUsagePage As Integer
    IsRange As Byte
    IsStringRange As Byte
    IsDesignatorRange As Byte
    IsAbsolute As Byte
    HasNull As Byte
    Reserved1 As Byte
    BitSize As Integer
    ReportCount As Integer
    Reserved2 As Integer
    Reserved3 As Integer
    Reserved4 As Integer
    Reserved5 As Integer
    Reserved6 As Integer
    UnitsExp As Long
    Units As Long
    LogicalMin As Long
    LogicalMax As Long
    PhysicalMin As Long
    PhysicalMax As Long
    UsageMin As Integer
    UsageMax As Integer
    StringMin As Integer
    StringMax As Integer
    DesignatorMin As Integer
    DesignatorMax As Integer
    DataIndexMin As Integer
    DataIndexMax As Integer
End Type

Public Type SP_DEVICE_INTERFACE_DATA
   cbSize As Long
   InterfaceClassGuid As GUID
   Flags As Long
   Reserved As Long
End Type

Public Type SP_DEVICE_INTERFACE_DETAIL_DATA
    cbSize As Long
    DevicePath As Byte
End Type

Public Type OVER_LAPPED
    Internal As Long
    InternalHigh As Long
    Offset As Long
    OffsetHigh As Long
    hEvent As Long
End Type

'Modified
'09/17/03
'by Paul Deignan
Public Type SECURITY_ATTRIBUTES
    nLength As Long
    lpSecurityDescriptor As Long
    bInheritHandle As Long
End Type


'******************************************************************************
'API functions, listed alphabetically
'******************************************************************************

Public Declare Function CloseHandle _
    Lib "kernel32" _
    (ByVal hObject As Long) _
As Long


'Modified
'09/17/03
'by Paul Deignan
'added lpSecurityAttributes as SECURITY_ATTRIBUTES
Public Declare Function CreateFile _
    Lib "kernel32" _
    Alias "CreateFileA" _
    (ByVal lpFileName As String, _
    ByVal dwDesiredAccess As Long, _
    ByVal dwShareMode As Long, _
    ByRef lpSecurityAttributes As SECURITY_ATTRIBUTES, _
    ByVal dwCreationDisposition As Long, _
    ByVal dwFlagsAndAttributes As Long, _
    ByVal hTemplateFile As Long) _
As Long

Public Declare Function FormatMessage _
    Lib "kernel32" _
    Alias "FormatMessageA" _
    (ByVal dwFlags As Long, _
    ByRef lpSource As Any, _
    ByVal dwMessageId As Long, _
    ByVal dwLanguageZId As Long, _
    ByVal lpBuffer As String, _
    ByVal nSize As Long, _
    ByVal Arguments As Long) _
As Long

Public Declare Function HidD_FreePreparsedData _
    Lib "hid.dll" _
    (ByVal PreparsedData As Long) _
As Long

Public Declare Function HidD_GetAttributes _
    Lib "hid.dll" _
    (ByVal HidDeviceObject As Long, _
    ByRef Attributes As HIDD_ATTRIBUTES) _
As Byte

Public Declare Sub HidD_GetHidGuid _
    Lib "hid.dll" _
    (ByRef HidGuid As GUID)

Public Declare Function HidD_GetPreparsedData _
    Lib "hid.dll" _
    (ByVal HidDeviceObject As Long, _
    ByRef PreparsedData As Long) _
As Byte

Public Declare Function HidP_GetCaps _
    Lib "hid.dll" _
    (ByVal PreparsedData As Long, _
    ByRef Capabilities As HIDP_CAPS) _
As Long

Public Declare Function HidP_GetValueCaps _
    Lib "hid.dll" _
    (ByVal ReportType As Integer, _
    ByRef ValueCaps As HIDP_VALUE_CAPS, _
    ByRef ValueCapsLength As Integer, _
    ByVal PreparsedData As Long) _
As Long

Public Declare Function HidP_GetSpecificValueCaps _
    Lib "hid.dll" _
    (ByVal ReportType As Integer, _
    ByVal UsagePage As Integer, _
    ByVal LinkCollection As Integer, _
    ByVal Usage As Integer, _
    ByRef ValueCaps As HIDP_VALUE_CAPS, _
    ByRef ValueCapsLength As Integer, _
    ByVal PreparsedData As Long) _
As Long

Public Declare Function lstrcpy _
    Lib "kernel32" _
    Alias "lstrcpyA" _
    (ByVal dest As String, _
    ByVal source As Long) _
As String

Public Declare Function lstrlen _
    Lib "kernel32" _
    Alias "lstrlenA" _
    (ByVal source As Long) _
As Long

Public Declare Function ReadFile _
    Lib "kernel32" _
    (ByVal hFile As Long, _
    ByRef lpBuffer As Byte, _
    ByVal nNumberOfBytesToRead As Long, _
    ByRef lpNumberOfBytesRead As Long, _
    ByRef lpOverlapped As OVER_LAPPED) _
As Long

Public Declare Function RtlMoveMemory _
    Lib "kernel32" _
    (dest As Any, _
    src As Any, _
    ByVal Count As Long) _
As Long

Public Declare Function SetupDiCreateDeviceInfoList _
    Lib "setupapi.dll" _
    (ByRef ClassGuid As GUID, _
    ByVal hwndParent As Long) _
As Long

Public Declare Function SetupDiDestroyDeviceInfoList _
    Lib "setupapi.dll" _
    (ByVal DeviceInfoSet As Long) _
As Long

Public Declare Function SetupDiEnumDeviceInterfaces _
    Lib "setupapi.dll" _
    (ByVal DeviceInfoSet As Long, _
    ByVal DeviceInfoData As Long, _
    ByRef InterfaceClassGuid As GUID, _
    ByVal MemberIndex As Long, _
    ByRef DeviceInterfaceData As SP_DEVICE_INTERFACE_DATA) _
As Long

Public Declare Function SetupDiGetClassDevs _
    Lib "setupapi.dll" _
    Alias "SetupDiGetClassDevsA" _
    (ByRef ClassGuid As GUID, _
    ByVal Enumerator As String, _
    ByVal hwndParent As Long, _
    ByVal Flags As Long) _
As Long

Public Declare Function SetupDiGetDeviceInterfaceDetail _
   Lib "setupapi.dll" _
   Alias "SetupDiGetDeviceInterfaceDetailA" _
   (ByVal DeviceInfoSet As Long, _
   ByRef DeviceInterfaceData As SP_DEVICE_INTERFACE_DATA, _
   ByVal DeviceInterfaceDetailData As Long, _
   ByVal DeviceInterfaceDetailDataSize As Long, _
   ByRef RequiredSize As Long, _
   ByVal DeviceInfoData As Long) _
As Long

Public Declare Function WriteFile _
    Lib "kernel32" _
    (ByVal hFile As Long, _
    ByRef lpBuffer As Byte, _
    ByVal nNumberOfBytesToWrite As Long, _
    ByRef lpNumberOfBytesWritten As Long, _
    ByVal lpOverlapped As Long) _
As Long
    
Public Declare Function CancelIo _
    Lib "kernel32" _
    (ByVal hFile As Long) _
As Long

Public Declare Function GetOverlappedResult _
    Lib "kernel32" _
    (ByVal hFile As Long, _
    ByRef lpOverlapped As OVER_LAPPED, _
    ByRef lpNumberOfBytesRead As Long, _
    ByVal bWait As Long) _
As Long

Public Declare Function CreateEvent _
    Lib "kernel32" _
    Alias "CreateEventA" _
    (ByVal lpEventAttributes As Long, _
    ByVal bManualReset As Long, _
    ByVal bInitialState As Long, _
    ByVal lpName As Long) _
As Long
  
Public Declare Function ResetEvent _
    Lib "kernel32" _
    (ByVal hEvent As Long) _
As Long
        
Public Declare Function HidP_GetUsageValue _
    Lib "hid.dll" _
    (ByVal ReportType As Integer, _
    ByVal UsagePage As Integer, _
    ByVal LinkCollection As Integer, _
    ByVal Usage As Integer, _
    ByRef UsageValue As Long, _
    ByVal PreparsedData As Long, _
    ByRef Report As Byte, _
    ByVal ReportLength As Long) _
As Long

Public Declare Function HidP_GetUsageValueArray _
    Lib "hid.dll" _
    (ByVal ReportType As Integer, _
    ByVal UsagePage As Integer, _
    ByVal LinkCollection As Integer, _
    ByVal Usage As Integer, _
    ByRef UsageValue As Byte, _
    ByVal UsageValueByteLength As Integer, _
    ByVal PreparsedData As Long, _
    ByRef Report As Byte, _
    ByVal ReportLength As Long) _
As Long

Public Declare Function HidD_GetFeature _
    Lib "hid.dll" _
    (ByVal HidDeviceObject As Long, _
    ByRef ReportBuffer As Byte, _
    ByVal ReportBufferLength As Long) _
As Byte

Public Declare Function HidD_SetFeature _
    Lib "hid.dll" _
    (ByVal HidDeviceObject As Long, _
    ByRef ReportBuffer As Byte, _
    ByVal ReportBufferLength As Long) _
As Byte


